cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

############################################################################
#########################	   read in data       ##########################
############################################################################

############ 2nd naive RNAseq
logfpkm2nd <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
# n_path <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he2_r3","he6_r1","he6_r2","he6_r3","n8_r1","n8_r2","n8_r3","n10_r2","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24m_r1","n24m_r2","n24m_r3","n24p_r1","n24p_r2","n24p_r3","niPS_r1","niPS_r2","niPS_r3")
nData_tmp <- logfpkm2nd[,n_path]
nfpkm2nd <- 2**nData_tmp - 1

n_time_point <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24p","n24m","niPS")
n_label <- c("hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T")
nData2ndfpkm <- cbind(apply(nfpkm2nd[,1:2],1,mean),apply(nfpkm2nd[,3:4],1,mean),apply(nfpkm2nd[,5:6],1,mean),apply(nfpkm2nd[,7:8],1,mean),apply(nfpkm2nd[,9:11],1,mean),apply(nfpkm2nd[,12:13],1,mean),apply(nfpkm2nd[,14:16],1,mean),apply(nfpkm2nd[,17:19],1,mean),apply(nfpkm2nd[,20:21],1,mean),apply(nfpkm2nd[,22:23],1,mean),apply(nfpkm2nd[,24:25],1,mean))
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)
############ 2nd primed RNAseq
pData2ndfpkm <- read.table("../data/paper.primed.fpkm.txt",header=T,row.names=1)

nData <- log2(nData2ndfpkm+1)
pData <- log2(pData2ndfpkm+1)
common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")
colnames(nData2ndfpkm) <- n_time_point
rownames(nData2ndfpkm) <- rownames(nfpkm2nd)

############ pre_implantation genes
pre_implantation <- rev(c("UTF1","NODAL","LEFTY1","FGF4","KLF5","KLF2","TFCP2L1","NLRP7","ALPPL2","DNMT3L","DPPA2","DPPA3","DPPA5"))

# pdf("naive.fpkm.exp.pca.pdf",width=7,height=7)
# genes <- row.names(nData)
# pca <- prcomp(t(logfpkm2nd[genes,n_path]))
# plot(pca$x[,"PC1"],pca$x[,"PC2"],pch=19,col=colorRampPalette(c("blue","red"), bias=1)(length(n_path)),main="PCA of 2nd naive samples")
# text(pca$x[,"PC1"],pca$x[,"PC2"]+3,n_path,col=colorRampPalette(c("blue","red"), bias=1)(length(n_path)))
# dev.off()
# library(edgeR)
# all_data <- logfpkm2nd[genes,n_path]
# batch <- as.factor(c(1,1,1,1,1,1,2,1,1,2,1,1,2,1,1,1,1,1,2,1,1,2,1,1,2,1,1,2,1,1,2))
# rmbatch_data <- removeBatchEffect(all_data,batch=batch)

# pdf("naive.rm_batch_effect_fpkm.exp.pca.pdf",width=7,height=7)
# pca <- prcomp(t(rmbatch_data))
# plot(pca$x[,"PC1"],pca$x[,"PC2"],pch=19,col=colorRampPalette(c("blue","red"), bias=1)(length(n_path)),main="PCA of 2nd naive samples")
# text(pca$x[,"PC1"],pca$x[,"PC2"]+3,n_path,col=colorRampPalette(c("blue","red"), bias=1)(length(n_path)))
# dev.off()

pdf("fpkm.exp.pca.pdf",width=7,height=7)
genes <- intersect(row.names(nData),row.names(pData))
pca <- prcomp(t(cbind(logfpkm2nd[genes,n_path],pData[genes,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")])))
plot(pca$x[,"PC1"],pca$x[,"PC2"],pch=19,col=colorRampPalette(c("blue","red"), bias=1)(length(c(n_path,"hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST"))),main="PCA of 2nd naive samples")
text(pca$x[,"PC1"],pca$x[,"PC2"]+3,c(n_path,"hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST"),col=colorRampPalette(c("blue","red"), bias=1)(length(n_path)))
dev.off()

library(edgeR)
paperpath <- c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")
all_data <- cbind(logfpkm2nd[genes,n_path],pData[genes,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")])
batch <- as.factor(c(rep(1,length(n_path)),rep(2,length(paperpath))))
rmbatch_data <- removeBatchEffect(all_data,batch=batch)

pdf("rm_batch_effect_fpkm.exp.pca.pdf",width=7,height=7)
pca <- prcomp(t(rmbatch_data))
plot(pca$x[,"PC1"],pca$x[,"PC2"],pch=19,col=colorRampPalette(c("blue","red"), bias=1)(length(c(n_path,"hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST"))),main="PCA of 2nd naive samples")
text(pca$x[,"PC1"],pca$x[,"PC2"]+3,c(n_path,"hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST"),col=colorRampPalette(c("blue","red"), bias=1)(length(n_path)))
dev.off()

nData <- cbind(apply(rmbatch_data[,1:2],1,mean),apply(rmbatch_data[,3:4],1,mean),apply(rmbatch_data[,5:6],1,mean),apply(rmbatch_data[,7:8],1,mean),apply(rmbatch_data[,9:11],1,mean),apply(rmbatch_data[,12:13],1,mean),apply(rmbatch_data[,14:16],1,mean),apply(rmbatch_data[,17:19],1,mean),apply(rmbatch_data[,20:21],1,mean),apply(rmbatch_data[,22:23],1,mean),apply(rmbatch_data[,24:25],1,mean))
colnames(nData) <- n_time_point
rownames(nData) <- genes

pData <- rmbatch_data[genes,paperpath]

############################################################################
####################        typical gene pattern       #####################
############################################################################
pdf("Fig2D.pdf",width=10,height=5)
plot_data_n <- nData[pre_implantation,c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")]
plot_data_p <- pData[pre_implantation,c("hiFT","d2","d5","d8","d14","d20","d24p","d24m","hiPST")]
par(oma=c(0.5,0.5,0.5,0.5),mar=c(6,4.5,2,1.5))
layout(matrix(c(rep(1,10),rep(2,10),rep(3,2)),nrow=1,ncol=22))
all_exp <- c(as.matrix(plot_data_n),as.matrix(plot_data_n)) # using same scale bar
zmax <- quantile(all_exp,0.99)
zmin <- quantile(all_exp,0.01)

# naive 
ColorRamp <- colorRampPalette(c("lightblue","white","red"), bias=1)(1000)   #color list
plotMatrix <- plot_data_n
plotMatrix[plotMatrix<zmin] <- zmin
plotMatrix[plotMatrix>zmax] <- zmax
ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="naive",ylab="")
axis(side=1,1:ncol(plotMatrix),labels=common_time_point,las=2)
axis(side=2,1:nrow(plotMatrix),labels=pre_implantation,las=2)
#primed
ColorRamp <- colorRampPalette(c("lightblue","white","red"), bias=1)(1000)   #color list
plotMatrix <- plot_data_p
plotMatrix[plotMatrix<zmin] <- zmin
plotMatrix[plotMatrix>zmax] <- zmax
ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="primed",ylab="")
axis(side=1,1:ncol(plotMatrix),labels=common_time_point,las=2)
axis(side=2,1:nrow(plotMatrix),labels=pre_implantation,las=2)
image(1,ColorLevels,t(matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1)),col=t(ColorRamp), xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=4,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
dev.off()
